<?php
# Start the session
session_start();
die();
include "../config/db.php";
include "../includes/language.php";
$conn = db_connect();

$qsettings = mysqli_query ( $conn, "SELECT * FROM tblsettings LIMIT 1" );
$qsettingsrow = mysqli_fetch_assoc ( $qsettings );

if( $_GET['language'] == "fr" )
{
	$language = "fr_FR";
	$language_short = "fr";
}
else
{
	$language = "en_GB";
	$language_short = "en";
}

$_SESSION ['language'] = "en_US";

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="../assets/images/favicon.png">
    <title><?php echo $qsettingsrow['title']; ?></title>
    <!-- Bootstrap Core CSS -->
    <link rel="stylesheet" type="text/css" href="../vendors/bootstrap/css/bootstrap.min.css">
    <!-- Custom CSS -->
    <link href="../css/style-admin.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="../css/colors/green.css" id="theme" rel="stylesheet">
	<link href="css/custom.css" id="theme" rel="stylesheet">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
<![endif]-->

	<!-- Form Validator -->
    <link href="../vendors/form-validator/theme-default.min.css" rel="stylesheet" type="text/css"> 
    <!-- Form Validator END -->
</head>

<body>
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <section id="wrapper">
        <div class="login-register" style="background-image:url(images/background.jpg); padding-top:20px;">        
            <div class="register-box card">
            <div class="panel-heading pt-4">
				<div id="logo" class="text-center">
					<a href="/" title="<?php echo $qsettingsrow['title']; ?>"><img src="../images/logo.png" alt="<?php echo $qsettingsrow['title']; ?>"/></a>
				</div>

				
			</div>
			<div class="card-body">
				<?php
			    if ( isset($_GET['already_registered']) )
				{
				?>
					<div class="panel panel-border panel-danger">
						<div class="panel-heading" style="border-top: 3px solid #f04c3e;">
							<h3 class="panel-title">Email Address Already Used</h3>
						</div>
						<div class="panel-body">
							<p>An account for the specified email address already exists. Please try logging in.</p>
						</div>
					</div>
				<?php
				}
				?>
				<hr>
				<div class="row">
					<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
						<p style="font-size: 19px;"><strong>If you have already created an account with <?php echo $qsettingsrow['title']; ?></strong> &nbsp;<a href="https://<?php echo $qsettingsrow['host_url']; ?>/login" class="btn btn-success btn-md" target="_parent">Please Click Here To Login</a></p>
						<p style="color:#b94a48"><strong>If you have not yet created an account with <?php echo $qsettingsrow['title']; ?> please create an account BELOW</strong> </p>
					</div>
				</div>
				
				
                <form class="form-horizontal validate-form m-t-20" method="post" action="send_registration.php?func=send" name="frmlogin" enctype="multipart/form-data">
                
					<div class="row">
						<div class="col-md-2 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("title"); ?> <font class="requirenote">*</font></label>
							<select name="title" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
							<option value="">Please Select</option>
								<?php
								$qtitle = mysqli_query ( $conn, "SELECT * FROM tblsettings_title ORDER BY title_en_US ASC" );
								while ( $qtitlerow = mysqli_fetch_assoc ( $qtitle ) )
								{
									echo "<option value=\"".$qtitlerow['id']."\">".$qtitlerow['title_en_US']."</option>";
								}
								?>
							</select>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("first_name"); ?> <font class="requirenote">*</font></label>
							<input type="text" name="name" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-3 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("middle_names"); ?> <font class="requirenote">*</font></label>
							<input type="text" name="middle_name" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-3 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("last_name"); ?> <font class="requirenote">*</font></label>
							<input type="text" name="surname" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("gender"); ?> <font class="requirenote">*</font></label>
							<select name="gender" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
							<option value="">Please Select</option>
								<?php
								$qgender = mysqli_query ( $conn, "SELECT * FROM tblsettings_gender ORDER BY title_en_US ASC" );
								while ( $qgenderrow = mysqli_fetch_assoc ( $qgender ) )
								{
									echo "<option value=\"".$qgenderrow['id']."\""; if($qgenderrow['id'] == $qclientrow['gender'])echo "selected"; echo ">".$qgenderrow['title_en_US']."</option>";
								}
								?>
							</select>
						</div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
						    <label><?php echo setlanguage("preferred_name_for_congress_name_tag"); ?> <font class="requirenote">*</font></label>
						    <input type="text" name="name_tag" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
					    </div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3" style="margin-bottom:20px;">
							<label><?php echo setlanguage("upload_profile_picture"); ?> <font class="requirenote">*</font></label>
							<input name="myfile" id="myfile" type="file" class="file" 
							 data-validation="required size mime" 
							 data-validation-max-size="3M" 
							 data-validation-allowing="jpg, jpeg, png, gif"
							 
							 data-validation-error-msg="This field is required" 
							 data-validation-error-msg-size="You can not upload images larger than 3M" 
							 data-validation-error-msg-mime="You can only upload images"
							>
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("organisation"); ?> <font class="requirenote">*</font></label>
							<input type="text" name="company" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("job_position"); ?> <font class="requirenote">*</font></label>
							<input type="text" name="function" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>

						<div id="company_type_div" class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("type_of_organisation"); ?> <font class="requirenote">*</font></label>
							<select class="form-control" id="company_type" name="company_type" onChange="onchange_organisation(this);" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<option value="Tax Administration">Tax Administration</option>
								<option value="Academic Community">Academic Community</option>
								<option value="Civil Society">Civil Society</option>
								<option value="Business Community">Business Community</option>
								<option value="Development Partner">Development Partner</option>
								<option value="International Organisation">International Organisation</option>
								<option value="Government">Government</option>
								<option value="NGO">NGO</option>
								<option value="Others">Other: Please Specify</option>
							</select>
						</div>
						<div id="company_other_div" class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("if_other"); ?> <font id="requirenote" class="requirenote" style="display:none;">*</font></label>
							<input type="text" name="company_other" id="company_other" class="form-control" disabled>
						</div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3 pl-0">
							<div class="card-header" style="background-color:#ffffff;">
								<h3 class="text-themecolor">Contact Details</h3>
							</div>
						</div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
                            <div class="row">
								<div class="col-md-6 col-sm-6 col-xs-12">
									<label><?php echo setlanguage("mobile_cellphone"); ?> <font class="xsmall requirenote">*</font></label>
									<div class="input-group">
										<select class="form-control col-md-4 col-sm-6 col-xs-12" name="mobile_country_code" data-validation="required" data-validation-error-msg="This field is required">
										<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
										<?php
										$qcountry = mysqli_query ( $conn, "SELECT * FROM tblsettings_countries ORDER BY title ASC" );
										while ( $qcountryrow = mysqli_fetch_assoc ( $qcountry ) )
										{
										?>
											<option value="<?php echo $qcountryrow['dial_code']; ?>"><?php echo $qcountryrow['title']." (".$qcountryrow['dial_code'].")"; ?></option>
										<?php
										}
										?>
										</select><br><br>
										<input type="text" name="mobile" class="form-control" placeholder="Mobile / Cellphone Number" data-validation="required" data-validation-error-msg="This field is required">
									</div>
							  	</div>
							  	<div class="col-md-6 col-sm-6 col-xs-12">
									<label><?php echo setlanguage("alternative_phone_number"); ?> <font class="xsmall requirenote">*</font></label>
									<div class="input-group">
										<select class="form-control col-md-4 col-sm-6 col-xs-12" name="phone_country_code" data-validation="required" data-validation-error-msg="This field is required">
										<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
										<?php
										$qcountry = mysqli_query ( $conn, "SELECT * FROM tblsettings_countries ORDER BY title ASC" );
										while ( $qcountryrow = mysqli_fetch_assoc ( $qcountry ) )
										{
										?>
											<option value="<?php echo $qcountryrow['dial_code']; ?>"><?php echo $qcountryrow['title']." (".$qcountryrow['dial_code'].")"; ?></option>
										<?php
										}
										?>
										</select><br><br>
										<input type="text" name="phone" class="form-control" placeholder="Alternative Phone Number" data-validation="required" data-validation-error-msg="This field is required">
									</div>
							  	</div>
							</div>
                        </div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("address_line_1"); ?> <font class="xsmall requirenote">*</font></label>
							<input type="text" name="street" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("address_line_2"); ?></label>
							<input type="text" name="street2" class="form-control">
						</div>
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
							<label><?php echo setlanguage("personal_city"); ?> <font class="xsmall requirenote">*</font></label>
							<input type="text" name="city" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>

						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("country_of_origin"); ?> <font class="xsmall requirenote">*</font></label>
							<select class="form-control" name="country_id" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<?php
								$qcountry = mysqli_query ( $conn, "SELECT * FROM tblsettings_countries ORDER BY title ASC" );
								while ( $qcountryrow = mysqli_fetch_assoc ( $qcountry ) )
								{
								?>
									<option value="<?php echo $qcountryrow['code']; ?>"><?php echo $qcountryrow['title']; ?></option>
								<?php
								}
								?>
							</select>
						</div>

						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("country_of_residence"); ?> <font class="xsmall requirenote">*</font></label>
							<select class="form-control" name="country_residence_id" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<?php
								$qcountry = mysqli_query ( $conn, "SELECT * FROM tblsettings_countries ORDER BY title ASC" );
								while ( $qcountryrow = mysqli_fetch_assoc ( $qcountry ) )
								{
								?>
									<option value="<?php echo $qcountryrow['code']; ?>"><?php echo $qcountryrow['title']; ?></option>
								<?php
								}
								?>
							</select>
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("region"); ?> <font class="xsmall requirenote">*</font></label>
							<select class="form-control" name="region" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<option value="Central Africa">Central Africa</option>
								<option value="Eastern Africa">Eastern Africa</option>
								<option value="Northern Africa">Northern Africa</option>
								<option value="Southern Africa">Southern Africa</option>
								<option value="Western AFrica">Western Africa</option>
								<option value="Antarctica">Antarctica</option>
								<option value="Asia">Asia</option>
								<option value="Australia">Australia</option>
								<option value="Europe">Europe</option>
								<option value="North America">North America</option>
								<option value="South America">South America</option>
							</select>
						</div>

						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("nationality"); ?> <font class="xsmall requirenote">*</font></label>
							<select class="form-control" name="nationality" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<?php
								$qcountry = mysqli_query ( $conn, "SELECT * FROM tblsettings_countries ORDER BY title ASC" );
								while ( $qcountryrow = mysqli_fetch_assoc ( $qcountry ) )
								{
								?>
									<option value="<?php echo $qcountryrow['code']; ?>"><?php echo $qcountryrow['title']; ?></option>
								<?php
								}
								?>
							</select>
						</div>

						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("primary_language"); ?> <font class="xsmall requirenote">*</font></label>
							<select class="form-control" name="language" data-validation="required" data-validation-error-msg="This field is required">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<option value="en_US">English</option>
								<option value="fr_FR">French</option>
								<option value="pt_PT">Portuguese</option>
							</select>
						</div>

						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("secondary_language_optional"); ?></label>
							<select class="form-control" name="language_secondary">
								<option value=""><?php echo setlanguage("--_please_select_--"); ?></option>
								<option value="en_US">English</option>
								<option value="fr_FR">French</option>
								<option value="pt_PT">Portuguese</option>
							</select>
						</div>

						<div class="col-md-12 col-sm-12 col-xs-12 pb-3 pl-0">
							<div class="card-header" style="background-color:#ffffff;">
								<h3 class="text-themecolor">Login Details</h3>
							</div>
						</div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Primary Email <font class="xsmall requirenote">*</font></label>
							<input type="email" name="email" class="form-control" 
								data-validation="required email server" 
								data-validation-url="validate_email.php" 
							 
								data-validation-error-msg="This field is required" 
								data-validation-error-msg-email="The email address is invalid" 
						    >
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Confirm Email <font class="xsmall requirenote">*</font></label>
							<input type="email" name="verify_email" class="form-control" data-validation="confirmation" data-validation-confirm="email" data-validation-error-msg="Please confirm your primary email address">
						</div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Secondary Email <font class="xsmall requirenote">*</font></label>
							<input type="email" name="second_email" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Verify Secondary email <font class="xsmall requirenote">*</font></label>
							<input type="email" name="verify_second_email" class="form-control" data-validation="confirmation" data-validation-confirm="second_email" data-validation-error-msg="Please confirm your secondary email address">
						</div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Password <font class="xsmall requirenote">*</font></label>
							<input type="text" name="password" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label>Verify Password <font class="xsmall requirenote">*</font></label>
							<input type="password" name="verify_password" class="form-control" data-validation="confirmation" data-validation-confirm="password" data-validation-error-msg="Please confirm your password">
						</div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("what_is_your_mothers_maiden_name"); ?> <font class="xsmall requirenote">*</font></label>
							<input type="text" name="security_answer_maiden_name" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						
						<div class="col-md-6 col-sm-6 col-xs-12 pb-3">
							<label><?php echo setlanguage("what_is_the_name_of_the_street_you_grew_up_in"); ?> <font class="xsmall requirenote">*</font></label>
							<input type="text" name="security_answer_city_born" class="form-control" data-validation="required" data-validation-error-msg="This field is required">
						</div>
						
						<div class="col-md-12 col-sm-12 col-xs-12 pb-3">
							<label><input type="checkbox" name="accept_terms" id="accept_terms" value="Yes" onClick="javascript:enableIndividualButton();" data-validation="required" data-validation-error-msg="This field is required"> <a href="http://www.atrnafrica.org/terms-and-conditions" target="_blank"><?php echo setlanguage("i_have_read_and_agreed_to_the_terms_and_conditions"); ?></a></label>
						</div>
						
					</div>

					<div class="form-group text-center m-t-40">
						<div class="col-xs-12">
							<button class="btn btn-success btn-block text-uppercase waves-effect waves-light" type="submit">Register</button>
						</div>
					</div>
					
				</form>
                
            </div>
          </div>
        </div>
        
    </section>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="../vendors/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="../vendors/bootstrap/js/popper.min.js"></script>
    <script src="../vendors/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="../js/jquery.slimscroll-admin.js"></script>
    <!--Wave Effects -->
    <script src="../js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="../js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="../vendors/sticky-kit-master/dist/sticky-kit.js"></script>
    <!--Custom JavaScript -->
    <script src="../js/custom-admin.min.js"></script>
    <!-- ============================================================== -->
    <!-- Style switcher -->
    <!-- ============================================================== -->
    <script src="../vendors/styleswitcher/jQuery.style.switcher.js"></script>
	
	<script>

	function onchange_organisation(checkbox) {
		if ($(checkbox).val() == "Others") {
			$('#requirenote').show();
			document.getElementById("company_other").disabled = false;
			document.getElementById("company_other").required = true;
		} else {
			$('#requirenote').hide();
			document.getElementById("company_other").disabled = true;
			document.getElementById("company_other").required = false;
		}
	}
	</script>
	
	<!-- Form Validator -->
    <script src="../vendors/form-validator/jquery.form-validator.min.js"></script>
    <script>
      $.validate({
        form : '.validate-form',
        modules : 'security, file'
      });
    </script>
    <!-- Form Validator END --> 
</body>

</html>